import { StarXpandCommand } from "star-io10-web";

export class LabelSample05_For203dpiAnd300dpi_DrinkLabel4_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText("${order_types}"),
            )
            .styleHorizontalPositionTo(0.0)
            .actionPrintText(
              "${datetime}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                48,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleInvert(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText(
                  "${order_number}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(4),
                ),
            )
            .actionPrintText(
              "(${item_number}/${number_of_items})",
              new StarXpandCommand.Printer.TextParameter().setWidth(6),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText(
                  "${time}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    17,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText("${product_name}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleHorizontalPositionTo(1.0)
                .actionPrintText("${item_list.detail}\n"),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText("${note}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "order_types" : "モバイルオーダー",
    "datetime" : "2023年09月18日 15:09",
    "order_number" : "M034",
    "item_number" : 1,
    "number_of_items" : 1,
    "time" : "15:09",
    "product_name" : "Star Drink/L",
    "item_list" : [
        {
            "detail" : "*Syrup/Less"
        },
        {
            "detail" : "*Ice/Less"
        },
        {
            "detail" : "*Pearl"
        }
    ],
    "note" : "お手荷物への同梱はカップ破損\\n防止のためお控えください。"
}`,
    );
  }
}
